	subroutine SOLVE(iout, idbg, Nn, Nb, NnNd, ldw, &
			ipar, fpar, ipar0, fpar0, &
			BCe, BCvalue, BCtype, C, T, Rn, &
			vB, rB, cB, lastB, &
			work, &
			Nr, order, Rr)		! ### new parameters ###
! solve equations and update

	implicit none
	integer iout, idbg
	integer Nn, Nb, NnNd			! array parameters
	integer lastB
	integer ldw
	integer ipar(16), ipar0(16)		! bCGstab integer parameters array
	real*8 fpar(16), fpar0(16)		! bCGstab real    parameters array
	integer rB(Nn+1)			! global  arrays (compact rows)
	integer cB(NnNd)			! global  arrays (compact columns)
	integer BCe(Nb,3)			! BC element numbers
	real*8 BCvalue(Nb,2)			! BC value (jx_bar, qx_bar or c_bar)
	character*1 BCtype(Nb)			! BC type ('N' or 'D')
	real*8 C   (Nn), T   (Nn)		! global  arrays
	real*8 Rn(Nn), work(ldw)		! work arrays
	real*8 vB(NnNd)				! global  arrays (compact values)

	integer Nr				! ### new parameters ###
	integer order(Nn,0:1)			! ### new parameters ###
	real*8 Rr(Nn)				! ### new parameters ###

	integer i, n, p

!	write(idbg,'(a)') ' --- SOLVE ---'	! ### TEMPORARY ###

! C    and T    are C(n+1) and Tn+1), respectively, on exit

	Rn =-T	! use matrix form

! modify Rn if Dirichlet BC
! order Rn
! permute Rn vector (in-place)
	call DVPERM (Nn, Rn, order(:,1)) 
! subtract Rr
	Rn = Rn - Rr
! permute C vector (in-place)
	call DVPERM (Nn, C, order(:,1)) 

! solve {[B]{C} = {R} using bCGstab
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
	  ipar = ipar0	! restore the original ipar
	  fpar = fpar0	! restore the original fpar

10	  call bCGstab(Nr, Rn(1), C(1), ipar, fpar , work)
	  if (ipar(1) .eq. 1) then
	    call AMUX(Nr, work(ipar(8)), work(ipar(9)), vB, cB, rB)
	    go to 10
	  else if(ipar(1) .ne. 0)	then
	    write(idbg,'(a)') ' --- SOLVE ---'	! ### TEMPORARY ###
	    write(idbg,*) 'ipar = ', ipar
	    write(idbg,*) 'fpar = ', fpar
	    stop 'problem in bCGstab'
	  endif
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

! permute C vector (in-place) back to the original order
	call DVPERM (Nn, C, order(:,0)) 

	return
	end

